#include "ExpressionDict.h"

#include "UtilStr.h"


ExpressionDict::ExpressionDict() :
	mVarDict( true ) {

}



void ExpressionDict::AddVar( char* inKey, float* inPtr ) {

	mVarDict.Put( new UtilStr( inKey ), inPtr );
}


void ExpressionDict::AddFcn( char* inKey, float* inFArray[], long inSize ) {
	FcnEntry* entry = new FcnEntry;

	entry -> mName.Assign( inKey );
	entry -> mName.Capitalize();
	entry -> mSize = inSize;
	entry -> mFcn = inFArray;
	
	mFcnEntries.addToHead( entry );
}


float* ExpressionDict::LookupVar( const UtilStr& inName ) {
	float* addr;
	
	if ( mVarDict.Get( &inName, &addr ) )
		return addr;
	else
		return NULL;
}


float** ExpressionDict::LookupFunc( const UtilStr& inName, long& outSize ) {
	FcnEntry* entry = (FcnEntry*) mFcnEntries.GetHead();
	
	while ( entry ) {
		if ( entry -> mName.compareTo( &inName ) == 0 ) {
			outSize = entry -> mSize;
			return entry -> mFcn;
		} 
			
		entry = (FcnEntry*) entry -> GetNext();
	} 
	
	outSize = 0;
	return NULL;
}
